<?php
session_start();
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}
include 'includes/koneksi.php';
?>

<!DOCTYPE html>
<html>

<head>
    <title>Dashboard - BumbuTrack Pro</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
</head>

<body>
    <nav class="navbar navbar-dark bg-dark">
        <span class="navbar-brand mb-0 h1">BumbuTrack Pro</span>
        <div class="navbar-nav d-flex flex-row">
            <a href="index.php" class="nav-link mr-3">Dashboard</a>
            <a href="produk/index.php" class="nav-link mr-3">Produk</a>
            <a href="pelanggan/index.php" class="nav-link mr-3">Pelanggan</a>
            <a href="penjualan/index.php" class="nav-link mr-3">Penjualan</a>
            <a href="kas/index.php" class="nav-link mr-3">Kas</a>
            <a href="laporan/index.php" class="nav-link mr-3">Laporan</a>
        </div>
        <span class="text-white">Login sebagai: <?= $_SESSION['username']; ?> | <a href="logout.php" class="text-white">Logout</a></span>
    </nav>
    <div class="container mt-4">
        <h3>Dashboard</h3>
        <div class="row">
            <div class="col-md-3">
                <div class="card text-white bg-primary mb-3">
                    <div class="card-body">
                        <h5 class="card-title">Total Pelanggan</h5>
                        <p class="card-text">
                            <?php
                            $q = $conn->query("SELECT COUNT(*) as total FROM pelanggan");
                            $d = $q->fetch_assoc();
                            echo $d['total'];
                            ?>
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-success mb-3">
                    <div class="card-body">
                        <h5 class="card-title">Total Produk</h5>
                        <p class="card-text">
                            <?php
                            $q = $conn->query("SELECT COUNT(*) as total FROM produk");
                            $d = $q->fetch_assoc();
                            echo $d['total'];
                            ?>
                        </p>
                    </div>
                </div>
            </div>
            <!-- Tambahkan modul dashboard lainnya sesuai kebutuhan -->
        </div>
    </div>
</body>

</html>