<?php
session_start();
if (!isset($_SESSION['username'])) {
    header("Location: ../login.php");
    exit;
}
include '../includes/koneksi.php';
?>

<!DOCTYPE html>
<html>

<head>
    <title>Data Kas - BumbuTrack Pro</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
</head>

<body>
    <nav class="navbar navbar-dark bg-dark">
        <span class="navbar-brand mb-0 h1">BumbuTrack Pro</span>
        <div class="navbar-nav d-flex flex-row">
            <a href="../index.php" class="nav-link mr-3">Dashboard</a>
            <a href="../produk/index.php" class="nav-link mr-3">Produk</a>
            <a href="../pelanggan/index.php" class="nav-link mr-3">Pelanggan</a>
            <a href="../penjualan/index.php" class="nav-link mr-3">Penjualan</a>
            <a href="../kas/index.php" class="nav-link mr-3 active">Kas</a>
            <a href="../laporan/index.php" class="nav-link mr-3">Laporan</a>
        </div>
        <span class="text-white">Login sebagai: <?= $_SESSION['username']; ?> | <a href="../logout.php" class="text-white">Logout</a></span>
    </nav>
    <div class="container mt-4">
        <h3>Rekap Kas</h3>
        <a href="tambah.php" class="btn btn-primary mb-3">+ Tambah Kas</a>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Tanggal</th>
                    <th>Jenis</th>
                    <th>Keterangan</th>
                    <th>Jumlah</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $q = $conn->query("SELECT * FROM kas ORDER BY tanggal DESC");
                $total = 0;
                while ($d = $q->fetch_assoc()):
                    $total += ($d['jenis'] == 'masuk') ? $d['jumlah'] : -$d['jumlah'];
                ?>
                    <tr>
                        <td><?= $d['tanggal']; ?></td>
                        <td><?= ucfirst($d['jenis']); ?></td>
                        <td><?= $d['keterangan']; ?></td>
                        <td>Rp<?= number_format($d['jumlah']); ?></td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
        <h5>Total Saldo: Rp<?= number_format($total); ?></h5>
    </div>
</body>

</html>