<?php
session_start();
if (!isset($_SESSION['username'])) {
    header("Location: ../login.php");
    exit;
}
include '../includes/koneksi.php';

$filter = "";
if (isset($_POST['tanggal']) && !empty($_POST['tanggal'])) {
    $tanggal = $_POST['tanggal'];
    $filter = "WHERE penjualan.tanggal = '$tanggal'";
}
?>

<!DOCTYPE html>
<html>

<head>
    <title>Laporan Penjualan - BumbuTrack Pro</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
</head>

<body>
    <nav class="navbar navbar-dark bg-dark">
        <span class="navbar-brand mb-0 h1">BumbuTrack Pro</span>
        <div class="navbar-nav d-flex flex-row">
            <a href="../index.php" class="nav-link mr-3">Dashboard</a>
            <a href="../produk/index.php" class="nav-link mr-3">Produk</a>
            <a href="../pelanggan/index.php" class="nav-link mr-3">Pelanggan</a>
            <a href="../penjualan/index.php" class="nav-link mr-3">Penjualan</a>
            <a href="../kas/index.php" class="nav-link mr-3">Kas</a>
            <a href="../laporan/index.php" class="nav-link mr-3 active">Laporan</a>
        </div>
        <span class="text-white">Login sebagai: <?= $_SESSION['username']; ?> | <a href="../logout.php" class="text-white">Logout</a></span>
    </nav>
    <div class="container mt-4">
        <h3>Laporan Penjualan</h3>

        <form method="POST" class="form-inline mb-3">
            <label class="mr-2">Tanggal:</label>
            <input type="date" name="tanggal" class="form-control mr-2" value="<?= isset($tanggal) ? $tanggal : ''; ?>">
            <button type="submit" class="btn btn-primary">Filter</button>
            <a href="index.php" class="btn btn-secondary ml-2">Reset</a>
        </form>

        <?php if(isset($_POST['tanggal']) && empty($_POST['tanggal'])): ?>
            <div class="alert alert-warning">Silakan pilih tanggal terlebih dahulu untuk melakukan filter.</div>
        <?php endif; ?>

        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Tanggal</th>
                    <th>Pelanggan</th>
                    <th>Produk</th>
                    <th>Jumlah</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $q = $conn->query("SELECT penjualan.*, pelanggan.nama as pelanggan, produk.nama as produk 
                               FROM penjualan 
                               JOIN pelanggan ON penjualan.pelanggan_id = pelanggan.id 
                               JOIN produk ON penjualan.produk_id = produk.id 
                               $filter ORDER BY penjualan.tanggal DESC");

                $grand_total = 0;
                while ($d = $q->fetch_assoc()):
                    $grand_total += $d['total'];
                ?>
                    <tr>
                        <td><?= $d['tanggal']; ?></td>
                        <td><?= $d['pelanggan']; ?></td>
                        <td><?= $d['produk']; ?></td>
                        <td><?= $d['jumlah']; ?></td>
                        <td>Rp<?= number_format($d['total']); ?></td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>

        <h5>Total Penjualan: Rp<?= number_format($grand_total); ?></h5>

        <form method="POST" action="export_excel.php" target="_blank">
            <input type="hidden" name="tanggal" value="<?= isset($tanggal) ? $tanggal : ''; ?>">
            <button class="btn btn-success">Export ke Excel</button>
        </form>
    </div>
</body>

</html>