<?php
session_start();
if (!isset($_SESSION['username'])) {
    header("Location: ../login.php");
    exit;
}
include '../includes/koneksi.php';
?>

<!DOCTYPE html>
<html>

<head>
    <title>Data Pelanggan - BumbuTrack Pro</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
</head>

<body>
    <nav class="navbar navbar-dark bg-dark">
        <span class="navbar-brand mb-0 h1">BumbuTrack Pro</span>
        <div class="navbar-nav d-flex flex-row">
            <a href="../index.php" class="nav-link mr-3">Dashboard</a>
            <a href="../produk/index.php" class="nav-link mr-3">Produk</a>
            <a href="../pelanggan/index.php" class="nav-link mr-3 active">Pelanggan</a>
            <a href="../penjualan/index.php" class="nav-link mr-3">Penjualan</a>
            <a href="../kas/index.php" class="nav-link mr-3">Kas</a>
            <a href="../laporan/index.php" class="nav-link mr-3">Laporan</a>
        </div>
        <span class="text-white">Login sebagai: <?= $_SESSION['username']; ?> | <a href="../logout.php" class="text-white">Logout</a></span>
    </nav>
    <div class="container mt-4">
        <h3>Data Pelanggan</h3>
        <a href="tambah.php" class="btn btn-primary mb-3">+ Tambah Pelanggan</a>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>Nama</th>
                    <th>Alamat</th>
                    <th>Telepon</th>
                    <th>Tipe</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $q = $conn->query("SELECT * FROM pelanggan");
                while ($d = $q->fetch_assoc()):
                ?>
                    <tr>
                        <td><?= $d['nama']; ?></td>
                        <td><?= $d['alamat']; ?></td>
                        <td><?= $d['telepon']; ?></td>
                        <td><?= ucfirst($d['tipe']); ?></td>
                        <td>
                            <a href="edit.php?id=<?= $d['id']; ?>" class="btn btn-sm btn-warning">Edit</a>
                            <a href="hapus.php?id=<?= $d['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Hapus data ini?')">Hapus</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</body>

</html>