<?php
session_start();
if (!isset($_SESSION['username'])) {
    header("Location: ../login.php");
    exit;
}
include '../includes/koneksi.php';
?>

<!DOCTYPE html>
<html>

<head>
    <title>Data Penjualan - BumbuTrack Pro</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
</head>

<body>
    <nav class="navbar navbar-dark bg-dark">
        <span class="navbar-brand mb-0 h1">BumbuTrack Pro</span>
        <div class="navbar-nav d-flex flex-row">
            <a href="../index.php" class="nav-link mr-3">Dashboard</a>
            <a href="../produk/index.php" class="nav-link mr-3">Produk</a>
            <a href="../pelanggan/index.php" class="nav-link mr-3">Pelanggan</a>
            <a href="../penjualan/index.php" class="nav-link mr-3 active">Penjualan</a>
            <a href="../kas/index.php" class="nav-link mr-3">Kas</a>
            <a href="../laporan/index.php" class="nav-link mr-3">Laporan</a>
        </div>
        <span class="text-white">Login sebagai: <?= $_SESSION['username']; ?> | <a href="../logout.php" class="text-white">Logout</a></span>
    </nav>
    <div class="container mt-4">
        <h3>Riwayat Penjualan</h3>
        <a href="tambah.php" class="btn btn-primary mb-3">+ Transaksi Baru</a>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Tanggal</th>
                    <th>Pelanggan</th>
                    <th>Produk</th>
                    <th>Jumlah</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $q = $conn->query("SELECT penjualan.*, pelanggan.nama as pelanggan, produk.nama as produk 
                               FROM penjualan 
                               JOIN pelanggan ON penjualan.pelanggan_id = pelanggan.id 
                               JOIN produk ON penjualan.produk_id = produk.id 
                               ORDER BY penjualan.tanggal DESC");
                while ($d = $q->fetch_assoc()):
                ?>
                    <tr>
                        <td><?= $d['tanggal']; ?></td>
                        <td><?= $d['pelanggan']; ?></td>
                        <td><?= $d['produk']; ?></td>
                        <td><?= $d['jumlah']; ?></td>
                        <td>Rp<?= number_format($d['total']); ?></td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</body>

</html>