<?php
session_start();
if (!isset($_SESSION['username'])) {
    header("Location: ../login.php");
    exit;
}
include '../includes/koneksi.php';

if (isset($_POST['simpan'])) {
    $pelanggan = $_POST['pelanggan_id'];
    $produk = $_POST['produk_id'];
    $jumlah = $_POST['jumlah'];
    $tanggal = date('Y-m-d');

    $q = $conn->query("SELECT harga, stok FROM produk WHERE id='$produk'");
    $d = $q->fetch_assoc();
    $total = $d['harga'] * $jumlah;
    $stok_baru = $d['stok'] - $jumlah;

    if ($stok_baru >= 0) {
        $conn->query("INSERT INTO penjualan (tanggal, pelanggan_id, produk_id, jumlah, total) 
                      VALUES ('$tanggal', '$pelanggan', '$produk', '$jumlah', '$total')");
        $conn->query("UPDATE produk SET stok='$stok_baru' WHERE id='$produk'");
        header("Location: index.php");
    } else {
        $error = "Stok tidak mencukupi!";
    }
}
?>

<!DOCTYPE html>
<html>

<head>
    <title>Transaksi Baru - BumbuTrack Pro</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
</head>

<body>
    <nav class="navbar navbar-dark bg-dark">
        <span class="navbar-brand mb-0 h1">BumbuTrack Pro</span>
        <div class="navbar-nav d-flex flex-row">
            <a href="../index.php" class="nav-link mr-3">Dashboard</a>
            <a href="../produk/index.php" class="nav-link mr-3">Produk</a>
            <a href="../pelanggan/index.php" class="nav-link mr-3">Pelanggan</a>
            <a href="../penjualan/index.php" class="nav-link mr-3 active">Penjualan</a>
            <a href="../kas/index.php" class="nav-link mr-3">Kas</a>
            <a href="../laporan/index.php" class="nav-link mr-3">Laporan</a>
        </div>
        <span class="text-white">Login sebagai: <?= $_SESSION['username']; ?> | <a href="../logout.php" class="text-white">Logout</a></span>
    </nav>
    <div class="container mt-4">
        <h3>Transaksi Penjualan Baru</h3>
        <?php if (isset($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>
        <form method="POST">
            <div class="form-group">
                <label>Pelanggan</label>
                <select name="pelanggan_id" class="form-control" required>
                    <option value="">Pilih</option>
                    <?php
                    $res = $conn->query("SELECT * FROM pelanggan");
                    while ($row = $res->fetch_assoc()):
                    ?>
                        <option value="<?= $row['id']; ?>"><?= $row['nama']; ?></option>
                    <?php endwhile; ?>
                </select>
            </div>
            <div class="form-group">
                <label>Produk</label>
                <select name="produk_id" class="form-control" required>
                    <option value="">Pilih</option>
                    <?php
                    $res = $conn->query("SELECT * FROM produk");
                    while ($row = $res->fetch_assoc()):
                    ?>
                        <option value="<?= $row['id']; ?>"><?= $row['nama']; ?> (Stok: <?= $row['stok']; ?>)</option>
                    <?php endwhile; ?>
                </select>
            </div>
            <div class="form-group">
                <label>Jumlah</label>
                <input type="number" name="jumlah" class="form-control" required>
            </div>
            <button name="simpan" class="btn btn-success">Simpan</button>
            <a href="index.php" class="btn btn-secondary">Kembali</a>
        </form>
    </div>
</body>

</html>