<?php
session_start();
if (!isset($_SESSION['username'])) {
    header("Location: ../login.php");
    exit;
}
include '../includes/koneksi.php';

// Filter untuk stok rendah
$filter = "";
if (isset($_GET['stok_rendah']) && $_GET['stok_rendah'] == 1) {
    $filter = "WHERE stok <= stok_minimum";
}
?>

<!DOCTYPE html>
<html>

<head>
    <title>Data Produk - BumbuTrack Pro</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
</head>

<body>
    <nav class="navbar navbar-dark bg-dark">
        <span class="navbar-brand mb-0 h1">BumbuTrack Pro</span>
        <div class="navbar-nav d-flex flex-row">
            <a href="../index.php" class="nav-link mr-3">Dashboard</a>
            <a href="../produk/index.php" class="nav-link mr-3 active">Produk</a>
            <a href="../pelanggan/index.php" class="nav-link mr-3">Pelanggan</a>
            <a href="../penjualan/index.php" class="nav-link mr-3">Penjualan</a>
            <a href="../kas/index.php" class="nav-link mr-3">Kas</a>
            <a href="../laporan/index.php" class="nav-link mr-3">Laporan</a>
        </div>
        <span class="text-white">Login sebagai: <?= $_SESSION['username']; ?> | <a href="../logout.php" class="text-white">Logout</a></span>
    </nav>
    <div class="container mt-4">
        <h3>Data Produk</h3>
        
        <div class="mb-3">
            <a href="tambah.php" class="btn btn-primary">+ Tambah Produk</a>
            <?php if(isset($_GET['stok_rendah']) && $_GET['stok_rendah'] == 1): ?>
                <a href="index.php" class="btn btn-secondary ml-2">Tampilkan Semua</a>
            <?php else: ?>
                <a href="index.php?stok_rendah=1" class="btn btn-warning ml-2">Cek Stok Rendah</a>
            <?php endif; ?>
        </div>
        
        <?php if(isset($_GET['stok_rendah']) && $_GET['stok_rendah'] == 1): ?>
            <div class="alert alert-warning">
                <strong>Perhatian!</strong> Menampilkan produk dengan stok di bawah atau sama dengan stok minimum.
            </div>
        <?php endif; ?>
        
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Nama Produk</th>
                    <th>Jenis</th>
                    <th>Stok</th>
                    <th>Harga</th>
                    <th>Stok Minimum</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $q = $conn->query("SELECT * FROM produk $filter");
                while ($d = $q->fetch_assoc()):
                    $stok_warning = ($d['stok'] <= $d['stok_minimum']) ? 'class="table-danger"' : '';
                ?>
                    <tr <?= $stok_warning ?>>
                        <td><?= $d['nama']; ?></td>
                        <td><?= ucfirst($d['jenis']); ?></td>
                        <td><?= $d['stok']; ?></td>
                        <td>Rp<?= number_format($d['harga']); ?></td>
                        <td><?= $d['stok_minimum']; ?></td>
                        <td>
                            <a href="edit.php?id=<?= $d['id']; ?>" class="btn btn-sm btn-warning">Edit</a>
                            <a href="hapus.php?id=<?= $d['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Hapus produk ini?')">Hapus</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</body>

</html>